/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.dialog;

import filenet.vw.api.VWParticipant;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.property.VWWflowGroupsTableData;
import filenet.vw.toolkit.runtime.resources.VWResource;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.VWUsersAndGroupsPanel;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import filenet.vw.toolkit.utils.uicontrols.security.IVWUsersAndGroupsPanel;
import filenet.vw.toolkit.utils.uicontrols.security.VWFilteredUsersAndGroupsPanel;
import filenet.vw.toolkit.utils.wfdefinition.VWDefaultSessionProxy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class VWManageWorkflowGroupsDialog
extends VWModalDialog {
    private Vector m_workflowGroups = null;
    private int m_selected = -1;
    private Vector m_names = new Vector();
    private Vector m_dialogWorkflowGroups = new Vector();
    private VWParticipantItem[] m_participantItems = null;
    private IVWUsersAndGroupsPanel m_usersAndGroupsPanel = null;
    private JLabel m_wfGroupsLabel = null;
    private JComboBox m_wfGroupsCombo = null;
    private DefaultComboBoxModel m_wfGroupsModel = null;
    private JButton m_okButton = null;
    private JButton m_cancelButton = null;
    private JButton m_helpButton = null;
    private boolean m_bCanceled = true;
    private Frame m_parentFrame = null;
    private VWLabelListCellRenderer m_customComboBoxRenderer = new VWLabelListCellRenderer();

    public VWManageWorkflowGroupsDialog(Frame parentFrame, Vector workflowGroups, int selected) {
        super(parentFrame);
        this.m_parentFrame = parentFrame;
        this.m_workflowGroups = workflowGroups;
        this.initData();
        this.setupLayout();
        this.m_wfGroupsCombo.setSelectedIndex(-1);
        this.m_wfGroupsCombo.setSelectedIndex(selected);
        this.updateControls();
    }

    protected void initData() {
        for (int i = 0; i < this.m_workflowGroups.size(); ++i) {
            Object obj = this.m_workflowGroups.elementAt(i);
            if (obj instanceof VWWflowGroupsTableData) {
                VWWflowGroupsTableData workflowGroup = (VWWflowGroupsTableData)obj;
                this.m_dialogWorkflowGroups.addElement(workflowGroup.getValue());
                this.m_names.addElement(workflowGroup.getName());
                continue;
            }
            this.m_dialogWorkflowGroups.addElement(null);
        }
    }

    protected void initSelected(int selected) {
        this.m_participantItems = null;
        if (this.m_names != null && this.m_names.size() > 0 && selected < this.m_names.size()) {
            Object obj = this.m_dialogWorkflowGroups.elementAt(selected);
            if (obj != null && obj instanceof VWParticipant[]) {
                VWParticipant[] participants = (VWParticipant[])obj;
                if (participants != null && participants.length == 1 && participants[0].getParticipantName().length() == 0) {
                    this.m_participantItems = null;
                } else {
                    this.m_participantItems = new VWParticipantItem[participants.length];
                    for (int i = 0; i < participants.length; ++i) {
                        this.m_participantItems[i] = new VWParticipantItem(participants[i]);
                    }
                }
            } else {
                this.m_participantItems = null;
            }
            this.m_selected = selected;
        }
    }

    private void addListeners() {
        this.m_wfGroupsCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    VWManageWorkflowGroupsDialog.this.updateSelectedStep();
                    VWManageWorkflowGroupsDialog.this.performSelectWorkflowGroup();
                }
            }
        });
        this.m_okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VWManageWorkflowGroupsDialog.this.m_bCanceled = false;
                try {
                    VWManageWorkflowGroupsDialog.this.updateSelectedStep();
                    VWManageWorkflowGroupsDialog.this.updateAll();
                    VWManageWorkflowGroupsDialog.this.setVisible(false);
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                }
            }
        });
        this.m_cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VWManageWorkflowGroupsDialog.this.m_bCanceled = true;
                VWManageWorkflowGroupsDialog.this.setVisible(false);
            }
        });
        this.m_helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VWHelp.displayPage(VWHelp.Help_Process_Tracker + "bpfpt040.htm");
            }
        });
    }

    protected void setupLayout() {
        Container contentPane = this.getContentPane();
        this.setResizable(true);
        Dimension dim = VWStringUtils.stringToDimension(VWResource.s_manageWorkflowGroupsDialogDim);
        if (dim == null) {
            dim = new Dimension(500, 350);
        }
        this.setSize(dim.width, dim.height);
        this.setVisible(false);
        this.setTitle(VWResource.s_manageWorkflowGroups);
        this.m_wfGroupsLabel = new JLabel(VWResource.s_label.toString(VWResource.s_workflowGroup));
        this.m_wfGroupsModel = this.m_workflowGroups == null || this.m_workflowGroups.size() == 0 ? new DefaultComboBoxModel() : new DefaultComboBoxModel(this.m_workflowGroups){

            public Object getElementAt(int index) {
                Object obj = super.getElementAt(index);
                if (obj instanceof VWWflowGroupsTableData) {
                    return ((VWWflowGroupsTableData)obj).getName();
                }
                return obj;
            }
        };
        this.m_wfGroupsCombo = new JComboBox(this.m_wfGroupsModel);
        this.m_wfGroupsCombo.setRenderer(this.m_customComboBoxRenderer);
        try {
            this.m_usersAndGroupsPanel = VWDefaultSessionProxy.getSession().getSecurityDatabaseType() == 1 ? new VWFilteredUsersAndGroupsPanel(this, VWDefaultSessionProxy.getSession()) : new VWUsersAndGroupsPanel(VWDefaultSessionProxy.getSession());
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        this.m_okButton = new JButton(VWResource.s_ok);
        this.m_cancelButton = new JButton(VWResource.s_cancel);
        this.m_helpButton = new JButton(VWResource.s_help);
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 23;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(4, 0, 4, 4);
        mainPanel.add((Component)this.m_wfGroupsLabel, c);
        ++c.gridx;
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        mainPanel.add((Component)this.m_wfGroupsCombo, c);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 1;
        c.weighty = 1.0;
        mainPanel.add((Component)((JPanel)((Object)this.m_usersAndGroupsPanel)), c);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.add(this.m_okButton);
        buttonPanel.add(this.m_cancelButton);
        buttonPanel.add(this.m_helpButton);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(2, 0, 10, 0));
        contentPane.setLayout(new BorderLayout(6, 6));
        contentPane.add((Component)mainPanel, "Center");
        contentPane.add((Component)buttonPanel, "Last");
        this.addListeners();
    }

    public void addNotify() {
        super.addNotify();
        Font boldFont = null;
        Font font = null;
        font = this.getFont();
        if (font != null) {
            boldFont = new Font(font.getName(), 1, font.getSize());
        }
        if (boldFont != null) {
            this.m_wfGroupsLabel.setFont(boldFont);
        }
    }

    private void updateControls() {
        this.m_usersAndGroupsPanel.init(this.m_participantItems);
    }

    public boolean isCanceled() {
        return this.m_bCanceled;
    }

    private void performSelectWorkflowGroup() {
        this.m_selected = this.m_wfGroupsCombo.getSelectedIndex();
        this.initSelected(this.m_selected);
        this.updateControls();
    }

    private void updateSelectedStep() {
        if (this.m_selected == -1 || this.m_selected >= this.m_dialogWorkflowGroups.size()) {
            return;
        }
        VWParticipant[] participants = null;
        this.m_participantItems = this.m_usersAndGroupsPanel.getParticipants();
        if (this.m_participantItems == null) {
            participants = new VWParticipant[]{};
        } else {
            participants = new VWParticipant[this.m_participantItems.length];
            for (int i = 0; i < this.m_participantItems.length; ++i) {
                participants[i] = this.m_participantItems[i].getVWParticipant();
            }
        }
        this.m_dialogWorkflowGroups.removeElementAt(this.m_selected);
        this.m_dialogWorkflowGroups.insertElementAt(participants, this.m_selected);
    }

    private void updateAll() {
        for (int i = 0; i < this.m_workflowGroups.size(); ++i) {
            Object obj = this.m_workflowGroups.elementAt(i);
            if (!(obj instanceof VWWflowGroupsTableData)) continue;
            VWWflowGroupsTableData workflowGroup = (VWWflowGroupsTableData)obj;
            try {
                workflowGroup.setValue(this.m_dialogWorkflowGroups.elementAt(i));
                continue;
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
    }
}

